% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

clear simmoms

Agrowth         = [NaN; Yt(2:end)./Yt(1:end-1) - 1]; 
Rgrowth         = [NaN; Rt(2:end)./Rt(1:end-1) - 1]; 
siggrowth       = [NaN; sigt(2:end)./sigt(1:end-1) - 1]; 

% Reallocation --> Logs
REALLO          = log(Rt);
REALLO(REALLO==-Inf) = NaN;

% Atilde --> Logs
ATILDE          = log(Yt);

% Correlation between Atilde and total reallocation
simmoms{1,1}    = corr(ATILDE,REALLO,'rows','complete');

% Amount of capital reallocation, standard deviation over time
simmoms{2,1}    = std(log(Rt));

% Fraction of adjusters, standard deviation over time
simmoms{3,1}    = std(pit);

% Correlation between GDP and the std in APK's
simmoms{4,1}    = corr(ATILDE,sigt);

% Correlation between Atilde and the fraction of firms reallocating
simmoms{5,1}   = corr(ATILDE,pit,'rows','complete');

% Autocorrelation of Atilde
xvar            = [ones(length(ATILDE(1:end-1)),1), ATILDE(1:end-1)];
yvar            = ATILDE(2:end);
beta            = (xvar'*xvar)\(xvar'*yvar);
simmoms{6,1}   = beta(2);

% Standard deviation of Atilde 
simmoms{7,1}   = std(ATILDE);
